% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_tuning.R
\name{cluster_tuning}
\alias{cluster_tuning}
\title{ClusterONE Hyperparameters Tuning}
\usage{
cluster_tuning(
  refcpx,
  csize = 2,
  d = c(0.3, 0.5),
  p = c(2),
  max_overlap = c(0.5, 0.6),
  tpath = file.path(system.file("extdata", package = "MACP"))
)
}
\arguments{
\item{refcpx}{A list containing reference complexes
(i.e., corum complexes).}

\item{csize}{An integer, the minimum size of the predicted complexes.
Defualts to 2.}

\item{d}{A vector of number, density of predicted complexes.}

\item{p}{A vector of integer, penalty value for the inclusion of each node.}

\item{max_overlap}{A vector of number, specifies the maximum allowed
overlap between two clusters.}

\item{tpath}{A character string indicating the path to the project
directory that contains the interaction data. Interaction data must be
stored as .txt file and containing id1-id2-weight triplets. Defaults
to MACP/inst/extdata directory.}
}
\value{
A data.frame containing clustering performance across different
combination of parameters.
}
\description{
This function optimizes the choice of ClusterONE algorithm
parameters such as density, node penalty, and overlap score by comparing
clustering-derived partitions for each combination of parameters to known
labels (i.e., CORUM complexes) and assess the similarity between them
using quality measures including overlap score, sensitivity (Sn),
clustering-wise positive predictive value (PPV), geometric accuracy (Acc),
and maximum matching raio (MMR).It is recommended to first reduce
redundancy in the known reference complexes via
\code{\link{EliminateCpxRedundance}},then performs parameter tuning.
}
\details{
cluster_tuning
}
\references{
Nepusz, T., Yu, H., and Paccanaro, A. (2012a).
Detecting overlapping protein complexes in protein-protein interaction
networks. Nat. Methods 9, 471.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
