% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EliminateCpxRedundance.R
\name{EliminateCpxRedundance}
\alias{EliminateCpxRedundance}
\title{Hierarchical Clustering of Modules}
\usage{
EliminateCpxRedundance(
  rawCpx,
  custom_bg = NULL,
  sim_method = "euclidean",
  linkage = "average",
  h = 0.2
)
}
\arguments{
\item{rawCpx}{A list containing protein complexes}

\item{custom_bg}{Vector of proteins names to use as a background.
If given, refcpx will be first mapped to the background proteisn, followed
by removing redundancy in the refcpx.}

\item{sim_method}{c(euclidean",
"maximum", "manhattan", "canberra", "binary", or "minkowski"); Default
is euclidean}

\item{linkage}{c("average", "ward", "single", "complete", "mcquitty",
"median", "centroid"); Default is average.}

\item{h}{numeric scalar or vector with heights where the tree should be
cut; Defaults to 0.2}
}
\value{
List of unique complexes.
}
\description{
This function reduces redundancy in the reference complexes
by first computing the overlap of two complexes via Jaccard index,
followed by merging overlapping complexes with user-defined threshold
(here is 0.2).
}
\details{
EliminateCpxRedundance
}
\examples{
# predicted interactions
pred_ppi <- read.table(
system.file("extdata/ppi_input_ClusterONE.txt", package = "MACP"),
header = FALSE)
# get all the proteins in the predicted network
custom_bg <- union(pred_ppi$V1, pred_ppi$V2)
# reference complexes
data("refcpx")
# reduce redundancy in reference complexes
filt_cpx <- EliminateCpxRedundance(refcpx,
custom_bg,
sim_method = "euclidean",
linkage="average",
h = 0.2)
}
\author{
Matineh Rahmatbakhsh
}
