/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import com.sosnoski.util.array.IntArray;
import java.util.Arrays;
import uk.ac.rhul.cs.cl1.ClusterGrowthAction;
import uk.ac.rhul.cs.cl1.ClusterGrowthProcess;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;

public class GreedyClusterGrowthProcess
extends ClusterGrowthProcess {
    protected QualityFunction qualityFunction;
    protected double minDensity;
    protected boolean onlySingleNode = false;
    protected boolean contractionAllowed = true;
    protected boolean seedRemovalAllowed = true;
    protected boolean keepInitialSeeds = false;
    private NodeSet initialSeeds = null;

    public GreedyClusterGrowthProcess(MutableNodeSet nodeSet, double minDensity, QualityFunction qualityFunc) {
        super(nodeSet);
        this.setMinDensity(minDensity);
        this.setQualityFunction(qualityFunc);
        this.initialSeeds = nodeSet.freeze();
    }

    public boolean isSeedRemovalAllowed() {
        return this.seedRemovalAllowed;
    }

    public void setSeedRemovalAllowed(boolean seedRemovalAllowed) {
        this.seedRemovalAllowed = seedRemovalAllowed;
    }

    public boolean isContractionAllowed() {
        return this.contractionAllowed;
    }

    public void setContractionAllowed(boolean contractionAllowed) {
        this.contractionAllowed = contractionAllowed;
    }

    public double getMinDensity() {
        return this.minDensity;
    }

    public QualityFunction getQualityFunction() {
        return this.qualityFunction;
    }

    public void setMinDensity(double minDensity) {
        this.minDensity = Math.max(0.0, minDensity);
    }

    public void setQualityFunction(QualityFunction qualityFunc) {
        this.qualityFunction = qualityFunc;
    }

    public ClusterGrowthAction getSuggestedAction() {
        IntArray bestNodes = new IntArray();
        double quality = this.qualityFunction.calculate(this.nodeSet);
        boolean bestIsAddition = true;
        int n = this.nodeSet.size();
        if (n == 0) {
            return ClusterGrowthAction.terminate();
        }
        double den = (double)((n + 1) * n) / 2.0;
        double internalWeightLimit = this.minDensity * den - this.nodeSet.getTotalInternalEdgeWeight();
        if (this.debugMode) {
            System.err.println("Current nodeset: " + this.nodeSet);
            System.err.println("Current quality: " + quality);
        }
        double bestAffinity = quality;
        for (Integer node : this.nodeSet.getExternalBoundaryNodeIterator()) {
            double internalWeight = this.nodeSet.getTotalAdjacentInternalWeight(node);
            if (n >= 4 && internalWeight < internalWeightLimit) continue;
            double affinity = this.qualityFunction.getAdditionAffinity(this.nodeSet, node);
            if (this.debugMode) {
                System.err.println("Considering addition of " + node + ", affinity = " + affinity);
            }
            if (affinity > bestAffinity) {
                bestAffinity = affinity;
                bestNodes.clear();
                bestNodes.add(node);
                continue;
            }
            if (affinity != bestAffinity) continue;
            bestNodes.add(node);
        }
        if (this.isContractionAllowed() && this.nodeSet.size() > 1) {
            for (Integer node : this.nodeSet) {
                if (this.keepInitialSeeds && this.initialSeeds.contains(node)) continue;
                double affinity = this.qualityFunction.getRemovalAffinity(this.nodeSet, node);
                if (this.debugMode) {
                    System.err.println("Considering removal of " + node + ", affinity = " + affinity);
                }
                if (affinity < quality + 1.0E-12 || affinity < bestAffinity || this.nodeSet.isCutVertex(node)) continue;
                if (affinity > bestAffinity) {
                    bestAffinity = affinity;
                    bestNodes.clear();
                    bestNodes.add(node);
                    bestIsAddition = false;
                    continue;
                }
                if (bestIsAddition) {
                    bestNodes.clear();
                    bestIsAddition = false;
                }
                bestNodes.add(node);
            }
        }
        if (bestNodes.size() == 0 || bestAffinity == quality) {
            if (this.debugMode) {
                System.err.println("Proposing termination");
            }
            return ClusterGrowthAction.terminate();
        }
        if (bestNodes.size() > 1 && this.onlySingleNode) {
            bestNodes.setSize(1);
        }
        if (bestIsAddition) {
            if (this.debugMode) {
                System.err.println("Proposing addition of " + Arrays.toString(bestNodes.toArray()));
            }
            return ClusterGrowthAction.addition(bestNodes.toArray());
        }
        if (this.debugMode) {
            System.err.println("Proposing removal of " + Arrays.toString(bestNodes.toArray()));
        }
        return ClusterGrowthAction.removal(bestNodes.toArray());
    }
}

