% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCMC_MABOUST}
\alias{MCMC_MABOUST}
\title{Performs posterior sampling for the MABOUST design.}
\usage{
MCMC_MABOUST(Y, T1, X, B, NTreat, NOUT, PSPIKE)
}
\arguments{
\item{Y}{Ordinal Outcome Vector, labeled 1,...,J}

\item{T1}{Treatment Indicator, labeled 1,...,K.}

\item{X}{Matrix of patient covariates.}

\item{B}{Number of MCMC iterations to perform.}

\item{NTreat}{Number of treatments in consideration, i.e. K.}

\item{NOUT}{Number of ordinal outcome categories, i.e. J.}

\item{PSPIKE}{Prior probability of a pairwise null effect.}
}
\value{
List containing posterior distributions of \eqn{\bf{\theta}} and \eqn{\bf{\beta}}.
}
\description{
Performs posterior sampling for the MABOUST design.
}
