% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Curve-class.R
\docType{class}
\name{RLum.Data.Curve-class}
\alias{RLum.Data.Curve-class}
\title{Class \code{"RLum.Data.Curve"}}
\description{
Class for representing luminescence curve data.
}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class "character" containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class "character" containing curve type, allowed values are
"measured" or "predefined"}

\item{\code{data}}{Object of class \link{matrix} containing curve x and y data.
'data' can also be of type \code{RLum.Data.Curve} to change object values without
de-constructing the object. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{set_RLum(class = 'RLum.Data.Curve',
         data = Your.RLum.Data.Curve,
         recordType = 'never seen before')
}\if{html}{\out{</div>}}

would just change the \code{recordType}. Missing arguments  the value is taken
from the input object in 'data' (which is already an \code{RLum.Data.Curve}
object in this example)}
}}

\note{
The class should only contain data for a single curve. For additional
elements the slot \code{info} can be used (e.g. providing additional heating
ramp curve). Objects from the class \code{RLum.Data.Curve} are produced by other
functions (partly within \linkS4class{RLum.Analysis} objects),
namely: \link{Risoe.BINfileData2RLum.Analysis}, \link{read_XSYG2R}
}
\section{Create objects from this Class}{

Objects can be created by calls of the form
\code{set_RLum(class = "RLum.Data.Curve", ...)}.
}

\section{Class version}{
 0.5.1
}

\examples{

showClass("RLum.Data.Curve")

##set empty curve object
set_RLum(class = "RLum.Data.Curve")

}
\seealso{
\linkS4class{RLum}, \linkS4class{RLum.Data}, \link{plot_RLum}, \link{merge_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
