% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_SignalBackground.R
\name{remove_SignalBackground}
\alias{remove_SignalBackground}
\title{Remove Signal Background from \code{RLum.Data.Curve} Objects}
\usage{
remove_SignalBackground(
  object,
  object_bg = NULL,
  recordType = NULL,
  clean_up = TRUE
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} (\strong{required}): A non-empty \linkS4class{RLum.Analysis} object
with, e.g., OSL/IRSL/TL curves or a \link{list} of such object. If a list is provided
non-conform list elements are silently removed from the \link{list}}

\item{object_bg}{\linkS4class{RLum.Data.Curve}, a \link{list} of such objects, a \link{matrix} or \link{numeric} (\emph{optional}):
Sets the background as a curve that is subtracted from the record types set with \code{recordType}.
If you provide a \link{matrix} or \link{numeric} internally, everything is coerced to a \linkS4class{RLum.Data.Curve} object.
If you desire full freedom, you can construct a \link{list} of \linkS4class{RLum.Data.Curve} objects.}

\item{recordType}{\link{character} (\emph{optional}): provide the \code{recordType} subject to the
background subtraction. Subsequent curve selection uses \link{get_RLum}.
If set to \code{NULL} the record type of highest occurrence will be used. Example: \code{recordType = "TL (UVVIS)"}}

\item{clean_up}{\link{logical} (\emph{with default}): enable/disable background curve removal
after background subtraction. If \code{object_bg} is set, nothing is removed from
the input object as the background is already stored separately.}
}
\value{
Returns an \linkS4class{RLum.Analysis} object or a \link{list} of such objects.
}
\description{
Convenient (background) of luminescence curves using \link{merge_RLum}
}
\details{
The function aims to simplify a frequently encountered task: subtracting curves
or backgrounds from luminescence curves, such as OSL, TL, or RF. The function
presumes that if curves are presented in pairs, for instance, TL - TL,
the second curve represents a background signal that needs to be removed
from the first curve. Following the removal, the background curve is discarded from
the dataset. Alternatively, custom background curves can be provided,
which are then utilised for the subtraction. In essence, the function
utilises the \link{merge_RLum} function but simplifies the selection of pairs and curves.
}
\section{Function version}{
 0.1.0
}

\examples{

## load example dataset
xsyg <- read_XSYG2R(
system.file("extdata/XSYG_file.xsyg", package = "Luminescence"),
fastForward = TRUE,
verbose = FALSE)

## remove constant background from OSL curves
remove_SignalBackground(
object = xsyg,
object_bg = 100,
recordType = "OSL (UVVIS)")

## use a more elaborate examples
## with two TL curves (2nd is background)
xsyg_v1 <- set_RLum("RLum.Analysis", records = c(
 rep(xsyg[[1]]@records[[1]], 2),
 xsyg[[1]]@records[[4]],
 xsyg[[1]]@records[[4]],
 rep(xsyg[[1]]@records[[10]], 2),
 xsyg[[1]]@records[[4]],
 xsyg[[1]]@records[[4]]))

## remove background and strip background
## curves from the object
o <- remove_SignalBackground(
 object = xsyg_v1,
 recordType = "TL (UVVIS)")

}
\seealso{
\link{get_RLum}, \link{merge_RLum}, \linkS4class{RLum.Analysis},\linkS4class{RLum.Data.Curve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. remove_SignalBackground(): Remove Signal Background from RLum.Data.Curve Objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{datagen}
