% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_plot.R
\name{structure_plot}
\alias{structure_plot}
\title{Visualize microbial community composition structure based on tax summary object}
\usage{
structure_plot(
  taxobj,
  taxlevel,
  ptsize = 2,
  diagram = NULL,
  ellipse.level = 0.85,
  facet_row = NULL
)
}
\arguments{
\item{taxobj}{tax summary objects computed by \code{\link{tax_summary}}.}

\item{taxlevel}{taxonomy levels used for visualization.Must be one of
c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").}

\item{ptsize}{Numeric, default: 2. Size of point in plot. See
\code{\link[ggplot2]{geom_point}} for details.}

\item{diagram}{Character, default: NULL. A character indicating group diagram,
should be in c("ellipse", "stick", "polygon").}

\item{ellipse.level}{Numeric, default: 0.85. The level at which to draw an ellipse,
or, if type = "euclid", the radius of the circle to be drawn. See
\code{\link[ggplot2]{stat_ellipse}} for details.}

\item{facet_row}{Numeric, default: NULL. Number of rows when wrap panels. See
\code{\link[ggplot2]{facet_wrap}} for details.}
}
\value{
Microbial structure analysis object.
}
\description{
Function for visualization of microbial structure with PCAplot, PCoAplot and NMDSplot
}
\note{
\enumerate{
\item Do not use NMDS when warning: In metaMDS(t(inputframe)) :stress is (nearly) zero: you may have insufficient data
\item Ellipse not available when replicates less than 3, please use 'stick' or 'polygon' instead
}
}
\examples{
###data preparation####
data("Two_group")

###analysis####
set.seed(999)
community_structure<- structure_plot(taxobj = Two_group,taxlevel = "Base")
 #check output list in console (not run)
 ######Output list##
 #####Plot#
 ####PCAplot:named as('PCA_Plot')(1/3)
 ####PCoAplot:named as('PCoA_Plot')(2/3)
 ####NMDSplot:named as('NMDS_Plot')(3/3)
 #####Analysis object#
 ####PCA object:named as('PCA_object')
 ####PCoA object:named as('PCoA_object')
 ####NMDS object:named as ('NMDS_object')
 #####Coordinates dataframe#
 ####PCA Coordinates dataframe:named as('PCA_coordinates')
 ####PCoA Coordinates dataframe:named as('PCoA_coordinates')
 ####NMDS Coordinates dataframe:named as('NMDS_coordinates')
 ######Done##
 #check PERMANOVA results
 community_structure$PERMANOVA_statistics

 #extract plot
 community_structure$PCA_Plot
 community_structure$PCoA_Plot
 community_structure$NMDS_Plot

 #extract object
 PCA_obj<- community_structure$PCA_object
 print(PCA_obj)

 #extract coordinates frame
 PCA_coord<- community_structure$PCA_coordinates
 head(PCA_coord)

 #stick plot
 set.seed(999)
 community_structure<- structure_plot(taxobj = Two_group,taxlevel = "Base",diagram = "stick")
 community_structure$PCoA_Plot

 #faced form
 data("Facet_group")
 set.seed(999)
 community_structure<- structure_plot(taxobj = Facet_group,taxlevel = "Genus",diagram = "stick")
 community_structure$PERMANOVA_statistics
 community_structure$PCA_Plot
 community_structure$PCoA_Plot
 community_structure$NMDS_Plot
}
