% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{searchIsotopes}
\alias{searchIsotopes}
\title{Targeted isotopes search}
\usage{
searchIsotopes(
  msobject,
  label,
  adductsTable = LipidMS::adductsTable,
  ppm = 10,
  coelCutoff = 0.7,
  results,
  dbs
)
}
\arguments{
\item{msobject}{msobject.}

\item{label}{isotope employed for the experiment. It can be "13C" or "D".}

\item{adductsTable}{adducts table employed for lipids annotation.}

\item{ppm}{mass error tolerance.}

\item{coelCutoff}{coelution score threshold between isotopes. By default, 0.7.}

\item{results}{target list to search isotopes. If missing, all results from the
msobject are searched. It is used by \link{searchIsotopesmsbatch}.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
List with the isotopes for each compound in the results data frame.
}
\description{
This function uses annotation results of deisotoped data to search
for isotopes in raw data.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
