% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepByCE.R
\name{sepByCE}
\alias{sepByCE}
\title{Separate .mzXML files by CE}
\usage{
sepByCE(file, output)
}
\arguments{
\item{file}{path of the input .mzXML file}

\item{output}{a unique character value indicating the name of the output
files. The energy employed and .mzXML will be added automatically to each
file.}
}
\value{
As many .mzXML files as different collision energies employed.
}
\description{
Separation of .mzXML files from all-ions data by collision energy to work
with them separately.
}
\details{
This function has been designed based on mzXML files obtained from
.d files (Agilent) using msConvert tool, in which we can find the collision
energy information. In addition to separate files by collision energies, this
function also changes the MS level of the high energy scans from 2 to 1
allowing their treatment (peak-picking for each collision energy, alignment,
i.e) with common software (xcms, mzMine2, enviPick, etc).
}
\note{
Be careful with input and output arguments. For example, "file.mzXML"
would be the input argument and "file_sep" could be the output.
}
\examples{

\dontrun{
sepByCE("input_file.mzXML", "output_file")
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
