% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LinkedMatrix.R
\docType{methods}
\name{apply,LinkedMatrix-method}
\alias{apply,LinkedMatrix-method}
\title{Apply function for \code{\linkS4class{ColumnLinkedMatrix}} or
\code{\linkS4class{RowLinkedMatrix}} objects.}
\usage{
\S4method{apply}{LinkedMatrix}(X, MARGIN, FUN, chunkSize = 1000,
  verbose = FALSE, ...)
}
\arguments{
\item{X}{Either a \code{\linkS4class{ColumnLinkedMatrix}} or a
\code{\linkS4class{RowLinkedMatrix}} object.}

\item{MARGIN}{Use 1 to apply function over rows or 2 to apply function over
columns.}

\item{FUN}{The function to be applied.}

\item{chunkSize}{The number of columns or rows that are processed at a time
(see Details).}

\item{verbose}{Whether to print additional information.}

\item{...}{Optional arguments to FUN.}
}
\value{
Returns a \code{matrix} or a \code{list} with results from FUN.
}
\description{
This function brings chunks (of size \code{chunkSize}) of rows (if
\code{MARGIN} is 1) or columns (if \code{MARGIN} is 2) of the
\code{LinkedMatrix} instance into RAM as \code{matrix} objects and calls the
\code{apply} function of the base package for each chunk. Results from all
the chunks are collected and returned.
}

