% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPLindley.R
\name{DPLindley}
\alias{DPLindley}
\alias{ddplindley}
\alias{pdplindley}
\alias{qdplindley}
\alias{rdplindley}
\title{Discrete Power Lindley Distribution}
\source{
[d-p-q-r]dplindley are calculated directly from the definitions. \code{rdplindley} uses the discretize values.
}
\usage{
ddplindley(x, theta, alpha, log = FALSE)

pdplindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qdplindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rdplindley(n, theta, alpha)
}
\arguments{
\item{x, q}{vector of integer positive quantiles.}

\item{theta, alpha}{positive parameter.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{ddplindley} gives the probability mass function, \code{pdplindley} gives the distribution function, \code{qdplindley} gives the quantile function and \code{rdplindley} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Probability mass function, distribution function, quantile function and random number generation for the discrete power Lindley distribution with parameters theta and alpha.
}
\details{
Probability mass function
\deqn{P(X=x\mid \theta ,\alpha )=\sum\limits_{i=0}^{1}\left( -1\right) ^{i}\left( 1+{\frac{\theta }{\theta +1}}\left( x+i\right) ^{\alpha }\right) \ e^{-\theta \left( x+i\right) ^{\alpha}}}

\bold{Particular case:} \eqn{\alpha = 1} the one-parameter discrete Lindley distribution.
}
\examples{
set.seed(1)
x <- rdplindley(n = 1000, theta = 1.5, alpha = 0.5)
plot(table(x) / sum(table(x)))
points(unique(x),ddplindley(unique(x), theta = 1.5, alpha = 0.5))

## fires in Greece data (from Bakouch et al., 2014)
data(fires)
library(fitdistrplus)
fit <- fitdist(fires, 'dplindley', start = list(theta = 0.30, alpha = 1.0), discrete = TRUE)
gofstat(fit, discrete = TRUE)
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Ricardo P. de Oliveira \email{rpuziol.oliveira@gmail.com}
}
\references{
Ghitany, M. E., Al-Mutairi, D. K., Balakrishnan, N. and Al-Enezi, L. J., (2013). Power Lindley distribution and associated inference. \emph{Computational Statistics and Data Analysis}, \bold{64}, 20-33.

Mazucheli, J., Ghitany, M. E. and Louzada, F., (2013). Power Lindley distribution: Diferent methods of estimation and their applications to survival times data. \emph{Journal of Applied Statistical Science}, \bold{21}, (2), 135-144.
}
\seealso{
\code{\link[LindleyR]{PLindley}}.
}

