% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_branches.R
\name{lm_branches}
\alias{lm_branches}
\title{Add a "branches" layer to a lifemap_obj object.}
\usage{
lm_branches(
  data = NULL,
  color = NULL,
  var_color = NULL,
  size = 5,
  min = 2,
  max = 20,
  opacity = 0.5,
  FUN = NULL,
  legend = TRUE,
  legendPosition = c("topright", "bottomright", "bottomleft", "topleft")
)
}
\arguments{
\item{data}{A sub dataset to use, if NULL then all of the taxids from the lifemap object given to lifemap() will be used.}

\item{color}{Either a color for the branches or a palette if a variable is used to represent branches' color.}

\item{var_color}{A column name of the original dataframe to represent this variable by the color of branches.}

\item{size}{Either a numeric for the branche's thickness or a variable to be represented by the branche's thickness.}

\item{min}{An integer indicating the minimal thickness of the branches if the size is a column name.}

\item{max}{An integer indicating the maximal thickness of the branches if the size is a column name.}

\item{opacity}{An integer indicating branche's opacity.}

\item{FUN}{The function to be applied to infer values. If NULL values won't be inferred}

\item{legend}{A logical indicating whether or not to display the legend.}

\item{legendPosition}{c("topright", "bottomright", "bottomleft", "topleft"), the position of the legend.}
}
\value{
An lm_branches object containing all aesthetics details for one layer of branches
}
\description{
Add a "branches" layer to a lifemap_obj object.
}
\examples{
data(LM_eukaryotes)

lm_branches(var_color = "GC.", color = "Accent")

lm_branches(data = LM_eukaryotes$df[LM_eukaryotes$df$Group \%in\% "Plants",])

}
