% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InsuranceParameters.R
\name{initializeCosts}
\alias{initializeCosts}
\title{Initialize or modify a data structure for the definition of \link{InsuranceTarif} costs}
\usage{
initializeCosts(
  costs,
  alpha,
  Zillmer,
  beta,
  gamma,
  gamma.paidUp,
  gamma.premiumfree,
  gamma.contract,
  gamma.afterdeath,
  gamma.fullcontract,
  unitcosts,
  unitcosts.PolicyPeriod
)
}
\arguments{
\item{costs}{(optional) existing cost structure to duplicate / use as a starting point}

\item{alpha}{Alpha costs (charged once, relative to sum of premiums)}

\item{Zillmer}{Zillmer costs (charged once, relative to sum of premiums)}

\item{beta}{Collection costs (charged on each gross premium, relative to gross premium)}

\item{gamma}{Administration costs while premiums are paid (relative to sum insured)}

\item{gamma.paidUp}{Administration costs for paid-up contracts (relative to sum insured)}

\item{gamma.premiumfree}{Administration costs for planned premium-free period (reltaive to sum insured)}

\item{gamma.contract}{Administration costs for the whole contract period (relative to sum insured)}

\item{gamma.afterdeath}{Administration costs after the insured person has dies (for term-fix insurances)}

\item{gamma.fullcontract}{Administration costs for the full contract period,
even if the insured has already dies (for term-fix insurances)}

\item{unitcosts}{Unit costs (absolute monetary amount, during premium period)}

\item{unitcosts.PolicyPeriod}{Unit costs (absolute monetary amount, during full contract period)}
}
\description{
Initialize a cost matrix with dimensions: {CostType, Basis, Period}, where:
\describe{
\item{CostType:}{alpha, Zillmer, beta, gamma, gamma_nopremiums, unitcosts}
\item{Basis:}{SumInsured, SumPremiums, GrossPremium, NetPremium, Constant}
\item{Period:}{once, PremiumPeriod, PremiumFree, PolicyPeriod}
}
This cost structure can then be modified for non-standard costs using the \code{\link[=setCost]{setCost()}} function.
The main purpose of this structure is to be passed to \link{InsuranceContract} or
\link{InsuranceTarif} definitions.
}
\examples{
# empty cost structure (only 0 costs)
initializeCosts()

# the most common cost types can be given in initializeCosts()
initializeCosts(alpha = 0.04, Zillmer = 0.025, beta = 0.05, gamma.contract = 0.001)

# The same cost structure manually
costs.Bsp = initializeCosts();
costs.Bsp[["alpha", "SumPremiums", "once"]] = 0.04;
costs.Bsp[["Zillmer", "SumPremiums", "once"]] = 0.025;
costs.Bsp[["beta", "GrossPremium", "PremiumPeriod"]] = 0.05;
costs.Bsp[["gamma", "SumInsured", "PolicyPeriod"]] = 0.001;

# The same structure using the setCost() function:
library(magrittr)
costs.Bsp = initializeCosts() \%>\%
  setCost("alpha", "SumPremiums", "once", 0.04) \%>\%
  setCost("Zillmer", "SumPremiums", "once", 0.025) \%>\%
  setCost("beta", "GrossPremium", "PremiumPeriod", 0.05) \%>\%
  setCost("gamma", "SumInsured", "PolicyPeriod", 0.001)




}
