% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.hmd.R
\name{prepare.hmd}
\alias{prepare.hmd}
\title{Prepare HMD data for \code{lexis.hmd()}}
\usage{
prepare.hmd(file)
}
\arguments{
\item{file, }{the name of the 'Deaths by Lexis triangles' file downloaded from the Human Mortality Database.}
}
\description{
\code{prepare.hmd()} prepares the raw 'Deaths by Lexis triangles' HMD data for further use by \code{lexis.hmd}.
}
\details{
This function reads the raw data into R and transforms data to \code{numeric} and \code{Date}.
Furthermore seven columns (\code{upper, x1, x2, x3, y1, y2, y3}) that contain the coordinates of the triangles will be added.
The age group \code{110+} will be removed from the data.
}
\examples{
library(LexisPlotR)
# Load sample data
path <- system.file("extdata", "Deaths_lexis_sample.txt", package = "LexisPlotR")
deaths.triangles <- prepare.hmd(path)
}
\author{
Philipp Ottolinger
}

