% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis.hmd.R
\name{lexis.hmd}
\alias{lexis.hmd}
\title{Fill Lexis triangles by HMD data}
\usage{
lexis.hmd(lg, hmd.data, column)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis.grid()}.}

\item{hmd.data, }{a data.frame created with \code{prepare.hmd()}.}

\item{column}{character, the name of the column of \code{hmd.data} the triangles shall be filled with.}
}
\description{
The function opens an existing Lexis grid and fill the triangles according to data from the Human Mortality Database.
}
\details{
The function creates a subset of \code{hmd.data} that fits in the dimensions of the existing Lexis grid.
The triangles will be filled according to the data in \code{column}.
}
\examples{
library(LexisPlotR)
lg <- lexis.grid(year.start = 1980, year.end = 1985, age.start = 0, age.end = 5)
# Load sample data
path <- system.file("extdata", "Deaths_lexis_sample.txt", package = "LexisPlotR")
deaths.triangles <- prepare.hmd(path)
lexis.hmd(lg = lg, hmd.data = deaths.triangles, column = "Total")

### Plot data not explicitly present in HMD data
deaths.triangles$RatioMale <- deaths.triangles$Male / deaths.triangles$Total
lexis.hmd(lg, deaths.triangles, "RatioMale")
}
\author{
Philipp Ottolinger
}

