% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circumcenter.R
\name{Circumcenter}
\alias{Circumcenter}
\title{Computes the circumcenter of a given triangle, that is, the intersection of its three medians}
\usage{
Circumcenter(Tri, lines = F)
}
\arguments{
\item{Tri}{Triangle object, previously created with function \code{CreatePolygon}}

\item{lines}{Boolean. When \code{lines} = \code{TRUE}, the plot displays the lines that represent the medians of each of the sides of the triangle. If missing, it works as with \code{lines} = \code{FALSE}, so the lines are not displayed}
}
\value{
Vector which contains the xy-coordinates of the circumcenter of the triangle
}
\description{
\code{Circumcenter} computes the center of a triangle
}
\examples{
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Tri <- CreatePolygon(P1, P2, P3)
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
Draw(Tri, "transparent")
I <- Circumcenter(Tri, lines = TRUE)
Draw(I, "red")
}
\references{
http://mathworld.wolfram.com/Circumcenter.html
}
