% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimilarPolygon.R
\name{SimilarPolygon}
\alias{SimilarPolygon}
\title{Creates a similar polygon to a given one}
\usage{
SimilarPolygon(Poly, k)
}
\arguments{
\item{Poly}{Polygon object, previously created with function \code{CreatePolygon}}

\item{k}{Positive number that represents the expansion (k > 1) or contraction (k < 1) factor which is applied to the original polygon}
}
\value{
Returns a similar polygon, exapended or contracted, to the original polygon
}
\description{
\code{SimilarPolygon} creates a sheared polygon from a given one
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, "blue")
k <- 2
Poly_similar <- SimilarPolygon(Poly, k)
Draw(Translate(Poly_similar, c(-1,2)), "orange")
}
