% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvBT.R
\name{cvLassoBT}
\alias{cvLassoBT}
\title{Cross-validation for \code{LassoBT}}
\usage{
cvLassoBT(x, y, lambda = NULL, nlambda = 100L,
  lambda.min.ratio = ifelse(nobs < nvars, 0.01, 1e-04), nfolds = 5L,
  nperms = 1L, mc.cores = 1L, ...)
}
\arguments{
\item{x}{input matrix of dimension nobs by nvars; each row is an observation
vector.}

\item{y}{response variable; shoud be a numeric vector.}

\item{lambda}{user supplied \code{lambda} sequence of decreasing penalty
parameters. Typical usage is to allow the function to compute its own
\code{lambda} sequence. Inappropraite sequences may cause convergence
problems.}

\item{nlambda}{the number of lambda values. Must be at least 3.}

\item{lambda.min.ratio}{smallest value in \code{lambda} as a fraction of the
largest value at which all main effects coefficients are 0.}

\item{nfolds}{number of folds. Default is 5.}

\item{nperms}{the number of permuted datasets to apply k-folds corss-validation to. Default is 1 so
we carry out vanilla cross-validation.}

\item{mc.cores}{the number of cores to use. Only applicable when not in Windows as it uses
the \pkg{parallel} package to parallelise the computations.}

\item{...}{other arguments that can be passed to \code{LassoBT}.}
}
\value{
A list with components as below.
\describe{
  \item{\code{lambda}}{the sequence of \code{lambda} values used}
  \item{\code{cvm}}{a matrix of error estimates (with squared error loss). The rows correspond
   to different \code{lambda} values whilst the columns correspond to different iterations}
  \item{\code{BT_fit}}{a "\code{BT}" object from a fit to the full data.}
  \item{\code{cv_opt}}{a two component vector giving the cross-validation optimal \code{lambda} index
   and iteration}
  \item{\code{cv_opt_err}}{the minimal cross-validation error.}
}
}
\description{
Perform k-fold cross-validation potentially multiple times on permuted version of the data.
}
\examples{
x <- matrix(rnorm(100*250), 100, 250)
y <- x[, 1] + x[, 2] - x[, 1]*x[, 2] + x[, 3] + rnorm(100)
out <- cvLassoBT(x, y, iter_max=10, nperms=2)
}

