% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_GMM.R
\name{gamma_GMM}
\alias{gamma_GMM}
\title{Estimate gamma}
\usage{
gamma_GMM(z, skewness.x = 0, gamma.init = gamma_Taylor(z), robust = FALSE,
  tol = .Machine$double.eps^0.25, not.negative = FALSE,
  optim.fct = c("optimize", "nlminb"))
}
\arguments{
\item{z}{a numeric vector of data values.}

\item{skewness.x}{theoretical skewness of the input \eqn{X}; default:
\code{0}.}

\item{gamma.init}{starting value for \eqn{\gamma}; default:
\code{\link{gamma_Taylor}}.}

\item{robust}{logical; if \code{TRUE}, robust measure of asymmetry
(\code{\link{medcouple_estimator}}) will be used; default: \code{FALSE}.}

\item{tol}{a positive scalar; tolerance level for terminating the iterative
algorithm; default: \code{.Machine$double.eps^0.25}.}

\item{not.negative}{logical; if \code{TRUE}, the estimate for \eqn{\gamma} is
restricted to non-negative reals, which is useful for scale-family
Lambert W\eqn{\times} F random variables. Default: \code{FALSE}.}

\item{optim.fct}{string; which R optimization function should be used.  By
default it uses \code{\link[stats]{optimize}} which is about 8-10x faster
than \code{\link[stats]{nlminb}}.}
}
\value{
A list with two elements: 
\item{gamma}{ scalar; optimal \eqn{\gamma}, } 
\item{iterations}{number of iterations (\code{NA} for \code{"optimize"}).}
}
\description{
This function minimizes the Euclidean distance between the theoretical
    skewness of a skewed Lambert W x Gaussian random variable and the sample
    skewness of the back-transformed data \eqn{W_{\gamma}(\boldsymbol z)} as
    a function of \eqn{\gamma} (see References). Only an interative
    application of this function will give a good estimate of \eqn{\gamma}
    (see \code{\link{IGMM}}).
}
\examples{

# highly skewed
y <- rLambertW(n = 1000, theta = list(beta = c(1, 2), gamma = 0.5), 
               distname = "normal") 
gamma_GMM(y, optim.fct = "nlminb")
gamma_GMM(y)

}
\seealso{
\code{\link{delta_GMM}} for the heavy-tail version of this
function; \code{\link{medcouple_estimator}} for a robust measure of asymmetry;
\code{\link{IGMM}} for an iterative method to estimate all parameters
jointly.
}
\keyword{optimize}

