% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_input}
\alias{get.input}
\alias{get_input}
\title{Back-transform Y to X}
\usage{
get_input(y, tau, return.u = FALSE)

get.input(...)
}
\arguments{
\item{y}{a numeric vector of data values or an object of class
\code{LambertW_fit}.}

\item{tau}{named vector \eqn{\tau} which defines the variable transformation. Must have at least
\code{'mu_x'} and \code{'sigma_x'} element; see \code{\link{complete_tau}} for details.}

\item{return.u}{should the normalized input be returned; default:
\code{FALSE}.}

\item{...}{arguments passed to \code{get_input}.}
}
\value{
The (approximated) input data vector \eqn{\widehat{\boldsymbol
x}_{\tau}}.

For \code{gamma != 0} it uses the principal branch solution
\code{\link{W_gamma}(z, branch = 0)} to get a unique input.

For \code{gamma = 0} the back-transformation is bijective
(for any \eqn{\delta \geq 0, \alpha \geq 0}).

If \code{return.u = TRUE}, then it returns a list with 2 vectors
\item{u}{centered and normalized input \eqn{\widehat{\boldsymbol u}_{\theta}},}
\item{x}{input data \eqn{\widehat{\boldsymbol x}_{\theta}}.}
}
\description{
\code{get_input} back-transforms the observed data \eqn{\boldsymbol y} to the
(approximate) input data \eqn{\boldsymbol x_{\tau}} using
the transformation vector \eqn{\tau =
(\mu_x(\boldsymbol \beta), \sigma_x(\boldsymbol \beta), \gamma, \alpha, \delta)}.

Note that \code{get.input} should be deprecated; however, since this function
was explicitly referenced in Goerg (2011) I keep it here for future reference.
New code should use \code{get_input} exclusively.
}
\examples{
set.seed(12)

# unskew very skewed data
y <- rLambertW(n = 1000, theta = list(beta = c(0, 1), gamma = 0.3),
               distname = "normal")
normfit(y)
fit.gmm <- IGMM(y, type="s")

x <- get_input(y, fit.gmm$tau)
# the same as
x <- get_input(fit.gmm)
normfit(x) # symmetric Gaussian
}
\seealso{
\code{\link{get_output}}
}
\keyword{manip}

