% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cumm_breaks_metrics.R
\name{get_plots_cumm}
\alias{get_plots_cumm}
\title{Plot of tree profiles with the canopy base height (CBH) based on the breaking point method}
\usage{
get_plots_cumm(LAD_profiles, cummulative_LAD)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function from leafR package).
An object of the class text.}

\item{cummulative_LAD}{tree metrics derived from using breaking points on cummulative LAD (output of [get_cum_break()] function).
An object of the class text.}
}
\value{
A plot of the Canopy Base Height (CBH) and Leaf Area Density (LAD) percentage below and above the CBH.
}
\description{
This function plots the canopy base height (CBH) based on breaking point over the cummulative LAD values and gives the LAD percentage below and above that breaking point
}
\examples{
library(ggplot2)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

# Before running this example, make sure to run get_cum_break().
if (interactive()) {
cummulative_LAD <- get_cum_break()
LadderFuelsR::cummulative_LAD$treeID <- factor(LadderFuelsR::cummulative_LAD$treeID)

# Generate cumulative LAD plots
plots_trees_cumlad <- get_plots_cumm(LAD_profiles, cummulative_LAD)
}
}
\seealso{
\code{\link{get_cum_break}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
