% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standprop_yrly_to_param.R
\name{standprop_yearly_to_param}
\alias{standprop_yearly_to_param}
\title{Transfer standproperties height, maxlai, sai, densef, age to parameter list obeject}
\usage{
standprop_yearly_to_param(standprop_yearly, param_b90, out_yrs)
}
\arguments{
\item{standprop_yearly}{A data.frame or data.table with columns 'year', 'height', 'maxlai', 'sai', 'densef', 'age'.}

\item{param_b90}{A list object to update.}

\item{out_yrs}{Vector of years for which parameters should be updated.}
}
\value{
The param_b90 list-object with updated items maxlai, height, height_ini,
sai, sai_ini, densef, densef_ini, age, age_ini.
}
\description{
Takes a data.frame of yearly stand properties, trims/extends the columns height, maxlai,
sai, densef, and age for the years in \code{out_yrs}, and updates the provided parameter list.
}
\examples{
param_b90 <- set_paramLWFB90()
dat <- slb1_standprop

years <- 2002:2005
param.new <- standprop_yearly_to_param(dat,
                                       param_b90,
                                       years)

identical(param.new$maxlai, dat$maxlai[dat$year \%in\% years])
identical(param.new$height, dat$height[dat$year \%in\% years])
}
