% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_lwfbrook90.R
\name{r_lwfbrook90}
\alias{r_lwfbrook90}
\title{Interface function to the LWF-Brook90 model}
\usage{
r_lwfbrook90(
  siteparam,
  climveg,
  param,
  pdur,
  soil_materials,
  soil_nodes,
  precdat = NULL,
  output_log = TRUE,
  chk_input = TRUE,
  timelimit = Inf
)
}
\arguments{
\item{siteparam}{A [1,6] matrix with site level information: start year,
start doy, latitude, initial snow, initial groundwater, precipitation
interval.}

\item{climveg}{A matrix with 15 columns of climatic and vegetation data:
year, month, day, global radiation in MJ/(m² d), tmax (deg C), tmin (deg
C), vappres (kPa), wind (m/s), prec (mm), mesfl (mm), densef (-), stand
height (m), lai (m²/m²), sai (m²/m²), stand age (years).}

\item{param}{A numeric vector of model input parameters (for the right order
see \code{\link{param_to_rlwfbrook90}}).}

\item{pdur}{a [1,12]-matrix of precipitation durations (hours) for each
month.}

\item{soil_materials}{A matrix of the 8 soil materials parameters. When
imodel = 1 (Mualem-van Genuchten), these refer to: mat, ths, thr, alpha
(1/m), npar, ksat (mm/d), tort (-), stonef (-). When imodel = 2
(Clapp-Hornberger): mat, thsat, thetaf, psif (kPa), bexp, kf (mm/d), wetinf
(-), stonef (-).}

\item{soil_nodes}{A matrix of the soil model layers with columns nl (layer
number), layer midpoint (m), thickness (mm), mat, psiini (kPa), rootden
(-).}

\item{precdat}{A matrix of precipitation interval data with 6 columns: year,
month, day, interval-number (1:precint), prec, mesflp.}

\item{output_log}{Logical whether to print runtime output to console.}

\item{chk_input}{Logical whether to check for NaNs in model inputs.}

\item{timelimit}{Integer to set elapsed time limits for running the model.}
}
\value{
A list containing the daily and soil layer model outputs, along with
  an error code of the simulation (see \code{\link{run_LWFB90}}.
}
\description{
Passes input data matrices to the Fortran model code and returns the results
}
