% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_globrad.R
\name{calc_globrad}
\alias{calc_globrad}
\title{Calculate global solar radiation from sunshine duration hours}
\usage{
calc_globrad(dates, sunhours, lat, a0 = 0.25, b0 = 0.5, full_output = FALSE)
}
\arguments{
\item{dates}{Date vector}

\item{sunhours}{Vector of sunshine duration hours, same length as dates.}

\item{lat}{Latitude in decimal degrees.}

\item{a0}{Angström parameter a, defaults to 0.25.}

\item{b0}{Angström parameter b, defaults to 0.5.}

\item{full_output}{Return extraterrestrial radiation and daylength along with
global radiation?}
}
\value{
A sequence of global radiation in MJ/(m² d) with the length of dates,
  or (if \code{full_output = TRUE}) a \code{data.frame} holding day of year,
  dates, sunhours, daylength, and extraterrestrial and calculated global
  solar radiation. A warning is generated if some sunshine duration hours are
  higher than the expected daylength at the specified latitude.
}
\description{
Uses functions taken from the 'sirad' package to determine astronomical
daylength and extraterrestrial radiation, from which global radiation is
calculated using the Angström-formula.
}
\examples{
dates <- seq.Date(as.Date("2002-01-01"), as.Date("2003-12-31"), by = 'day')
calc_globrad(dates, sunhours = runif(365, 0, 7),lat = 52.8)
}
