skip("Will fail as long as the source codes differ slightly?!")
library(LWFBrook90R)

# ---- load test data ---------------------------------------------------------------
# b90.exe output produced using 'data-raw/data_for_testing/b90exe_output/create_b90exe_refdat.R'
load("data-raw/data_for_testing/b90exe_output/exe_output.rda")

# Run the model (be sure to use the same commands as in the above named R-script.)
# Set up the input data
data("slb1_soil")
data("slb1_meteo")
opts <- set_optionsLWFB90()
parms <- set_paramLWFB90()

soil <- cbind(slb1_soil, hydpar_wessolek_tab(texture = slb1_soil$texture))
output <- set_outputLWFB90()
output[,] <- 0L
output[,1:3] <- 1L
# produce model input
b90res <- run_LWFB90(options_b90 = opts,
                    param_b90 = parms,
                    climate = slb1_meteo,
                    soil = soil,
                    output = output)

test_that("inputs are equal", {
  expect_equal(b90res$model_input$options_b90,pkg_input$options_b90)
  expect_equal(b90res$model_input$param_b90,pkg_input$param_b90)
  expect_equal(b90res$model_input$standprop_daily,pkg_input$standprop_daily)
})



# ------------------------------------------------------------------------------
# Tests

tolerance_mm <- 0.001

# ----- ABOV-tests-----------------------------------------------------------

# columns to test
nms <- names(b90res$ABOVDAY.ASC) #[-which(names(b90res$BUDGDAY.ASC) %in% c("evap"))]

test_that("values in ABOVDAY are equal", {
  expect_equal(b90res$ABOVDAY.ASC[,nms, with = F], exe_res$ABOVDAY.ASC[,nms, with = F], tolerance = tolerance_mm)
})

nms <- nms[!nms %in% c("da", "doy")]
test_that("values in ABOVMON.ASC are equal", {
  expect_equal(b90res$ABOVMON.ASC[,nms, with = F], exe_res$ABOVMON.ASC[,nms, with = F], tolerance = tolerance_mm)
})

nms <- nms[nms != "mo"]
test_that("values in ABOVANN.ASC are equal", {
  expect_equal(b90res$ABOVANN.ASC[,nms, with = F], exe_res$ABOVANN.ASC[,nms, with = F], tolerance = tolerance_mm)
})

# ----- BUDGDAY-tests-----------------------------------------------------------

b90res$BUDGDAY.ASC[, intrs := intr+ints]
b90res$BUDGMON.ASC[, intrs := intr+ints]
b90res$BUDGANN.ASC[, intrs := intr+ints]
b90res$BUDGDAY.ASC[, c("intr", "ints") := NULL]
b90res$BUDGMON.ASC[, c("intr", "ints") := NULL]
b90res$BUDGANN.ASC[, c("intr", "ints") := NULL]
data.table::setnames(exe_res$BUDGANN.ASC, "intr+s", "intrs")
data.table::setnames(exe_res$BUDGMON.ASC, "intr+s", "intrs")
data.table::setnames(exe_res$BUDGDAY.ASC, "intr+s", "intrs")
exe_res$BUDGDAY.ASC$mesfl <- NULL
exe_res$BUDGMON.ASC$mesfl <- NULL
exe_res$BUDGANN.ASC$mesfl <- NULL

test_that("values in BUDGDAY are equal", {
  expect_equal(b90res$BUDGDAY.ASC, exe_res$BUDGDAY.ASC, tolerance = tolerance_mm)
})

test_that("values in BUDGMON are equal", {
  expect_equal(b90res$BUDGMON.ASC, exe_res$BUDGMON.ASC, tolerance = tolerance_mm)
})

test_that("values in BUDGANN are equal", {
  expect_equal(b90res$BUDGANN.ASC, exe_res$BUDGANN.ASC, tolerance = tolerance_mm)
})

# ----- EVAP-tests-----------------------------------------------------------

# column to test
nms <- names(b90res$EVAPDAY.ASC) #[-which(names(b90res$BUDGDAY.ASC) %in% c("evap"))]

test_that("values in EVAPDAY.ASC are equal", {
  expect_equal(b90res$EVAPDAY.ASC[,nms, with = F], exe_res$EVAPDAY.ASC[,nms, with = F], tolerance = tolerance_mm)
})

nms <- nms[!nms %in% c("da", "doy")]
test_that("values in EVAPMON.ASC are equal", {
  expect_equal(b90res$EVAPMON.ASC[,nms, with = F], exe_res$EVAPMON.ASC[,nms, with = F], tolerance = tolerance_mm)
})

nms <- nms[nms != "mo"]
test_that("values in EVAPANN.ASC are equal", {
  expect_equal(b90res$EVAPANN.ASC[,nms, with = F], exe_res$EVAPANN.ASC[,nms, with = F], tolerance = tolerance_mm)
})


# ----- MISC-tests -----------------------------------------------------------
exe_res[c("MISCANN.ASC","MISCMON.ASC", "EPVPANN.ASC")] <- NULL
b90res[c("MISCANN.ASC","MISCMON.ASC", "EPVPANN.ASC")] <- NULL
exe_res$MISCDAY.ASC$awat40 <- NULL

test_that("values in MISCDAY.ASC are equal", {
  expect_equal(b90res$MISCDAY.ASC, exe_res$MISCDAY.ASC, tolerance = 0.001)
})


# ----- SWAT-tests -----------------------------------------------------------
exe_res$SWATDAY.ASC$temperature <- NULL
exe_res$SWATMON.ASC$temperature <- NULL
exe_res$SWATANN.ASC$temperature <- NULL
exe_res$SWATANN.ASC <- exe_res$SWATANN.ASC[!is.na(yr),]

swat_wide <-  extract_layer_output(b90res$SWATDAY.ASC)
exe_swat_wide <-  extract_layer_output(exe_res$SWATDAY.ASC)
test_that("values in SWATDAY.ASC are equal", {
  expect_equal(swat_wide, exe_swat_wide, tolerance = 0.001)
})

swat_wide <-  extract_layer_output(b90res$SWATMON.ASC)
exe_swat_wide <-  extract_layer_output(exe_res$SWATMON.ASC)
test_that("values in SWATMON.ASC are equal", {
  expect_equal(swat_wide, exe_swat_wide, tolerance = 0.001)
})

swat_wide <-  extract_layer_output(b90res$SWATANN.ASC)
exe_swat_wide <-  extract_layer_output(exe_res$SWATANN.ASC)
test_that("values in SWATANN.ASC are equal", {
  expect_equal(swat_wide, exe_swat_wide, tolerance = 0.001)
})

# ----- BELO-tests -----------------------------------------------------------
exe_res$BELOANN.ASC <- exe_res$BELOANN.ASC[!is.na(yr),]

belo_wide <-  extract_layer_output(b90res$BELODAY.ASC)
exe_belo_wide <-  extract_layer_output(exe_res$BELODAY.ASC)

test_that("values in BELODAY.ASC are equal", {
  expect_equal(belo_wide, exe_belo_wide, tolerance = 0.001)
})

belo_wide <-  extract_layer_output(b90res$BELOMON.ASC)
exe_belo_wide <-  extract_layer_output(exe_res$BELOMON.ASC)
test_that("values in BELOMON.ASC are equal", {
  expect_equal(belo_wide, exe_belo_wide, tolerance = 0.001)
})

belo_wide <-  extract_layer_output(b90res$BELOANN.ASC)
exe_belo_wide <-  extract_layer_output(exe_res$BELOANN.ASC)
test_that("values in BELOANN.ASC are equal", {
  expect_equal(belo_wide, exe_belo_wide, tolerance = 0.001)
})







