% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataprep.R
\name{dataprep}
\alias{dataprep}
\title{Prepare Data}
\usage{
dataprep(dose, ntot, nfx)
}
\arguments{
\item{dose}{A numeric vector of unique, chemical concentrations (see Details).}

\item{ntot}{A numeric vector of the number of individuals that were tested at each
dose.}

\item{nfx}{A numeric vector of the number of individuals that were affected at each
dose.}
}
\value{
A data frame with eight columns (ordered by dose and proportion affected),
    seven numeric vectors and one logical vector:
  \itemize{
    \item \code{dose} = chemical concentrations.
    \item \code{ntot} = the number of individuals that were tested at each
      dose.
    \item \code{nfx} = the number of individuals that were affected at each
      dose.
    \item \code{rec} = the record number corresponding to the input vectors
      \code{dose}, \code{ntot}, \code{nfx}.
    \item \code{pfx} = the proportion of individuals that were affected at
      each dose.
    \item \code{log10dose} = log transformed dose, \code{log10(dose)}.
    \item \code{bitpfx} = probit transformed proportional affected,
      \code{\link{probit}(pfx)}.
    \item \code{fxcateg} = effects category: 0 for none affected, 100 for all
      affected, and 50 for other proportions affected.
    \item \code{LWkeep} = logical vector identifying records to keep for
      Litchfield and Wilcoxon (1949, step A1) method.
  }
}
\description{
Prepare dose-effect data for evaluation.
}
\details{
The input data are expected to be summarized by dose.
  If duplicate doses are provided, an error will be thrown.
}
\examples{
conc <- c(0.0625, 0.125, 0.25, 0.5, 1)
numtested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
dataprep(dose=conc, ntot=numtested, nfx=nalive)
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
  A simplified method of evaluating dose-effect experiments.
  Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
  \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}

