error <- function(errorvec) {

  for (i in 1:length(errorvec)) {
    errormessage(errorvec[i])
  }

  cat(length(errorvec), " error(s)\n\n")

  cat("Computation aborted.\n\n")
  
  stop()
}

errormessage <- function (errornum) {
  errorvec <- vector()
  errorvec[1] <- "Dimensions of relevance vector do not correspond to data dimensions."
  errorvec[2] <- "Dimensions of relevance matrix do not correspond to data dimensions."
  errorvec[3] <- "\'normalizescheme\' must contain exactly one value of the following normalize-scheme's: \'none\', \'ztransform\' \'iqr\', \'sumone\'."
  errorvec[4] <- "\'normalclasswise\' must contain exactly one value. This value must be \'none\' or correspond to a data-class."
  errorvec[5] <- "\'replaceNA\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[6] <- "\'replaceclasswise\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[7] <- "All data-classes must be represented by at least one prototype."
  errorvec[8] <- "The number of prototypes per class must be specified by a number of class \'numeric\' or \'integer\'."
  errorvec[9] <- "The number of prototypes per class must be whole number greater than 0."
  errorvec[10] <- "The number of epochs must be a whole number greater than 0."
  errorvec[11] <- "\'learningrate\' must contain one or \'epochs\' values of class \'numeric\'."
  errorvec[12] <- "All values of \'learningrate\' must be within the range of <0...1>."
  errorvec[13] <- "\'relrate\' must contain one or \'epochs\' values of class \'numeric\'."
  errorvec[14] <- "All values of \'relrate\' must be within the range of <0...1>."
  errorvec[15] <- "\'initscheme\' must contain exactly one value of the following initialisation-schemes: \'randomwindow\', \'zero\', \'randomsample\', \'mean\' \'classmean\'."
  errorvec[16] <- "\'distscheme\' must contain exactly one value of the following distance-schemes: \'manhattan\', \'euclidean\', \'custom\'."
  errorvec[17] <- "\'relevancemode\' must contain exactly one value of the following modes: \'normal\', \'relevance\', \'matrix\'."
  errorvec[18] <- "\'LVQscheme\' must contain exactly one value of the following LVQmodes: \'LVQ1\', \'cauchyschwarz\', \'renyi\'."
  errorvec[19] <- "\'customdist\' must contain exactly one value of class \'numeric\' or \'integer\'."
  errorvec[20] <- "\'customdist\' must be greater or equal to 1."
  errorvec[21] <- "\'show\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[22] <- "\'graphics\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[23] <- "Plotting of prototype progress is only available with 2-dimensional datasets."
  errorvec[25] <- "\'plotcurve\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[26] <- "\'validatescheme\' must contain exactly one value of the following validateschemes: \'train\', \'traintest\', \'nfold\'."
  errorvec[27] <- "\'nfold\' must contain exactly one value of class \'numeric\' or \'integer\'."
  errorvec[28] <- "\'nfold\' must be a whole number in the range of [2...number of datapoints]."
  errorvec[29] <- "Matrix variant is only available with euclidean distance scheme."
  errorvec[30] <- "\'progress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[31] <- "\'prototypeoutput\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[32] <- "\'relevanceoutput\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[33] <- "Relevanceoutput is only available in relevancemodes \'relevance\' and \'matrix\'."
  errorvec[34] <- "\'costcurve\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[35] <- "\'prototypeprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[36] <- "\'relevanceprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[37] <- "Relevanceprogress is only available in relevancemodes \'relevance\' and \'matrix\'."
  errorvec[38] <- "\'testerror\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[39] <- "Testerror-output is only available in validationschemes \'traintest\' and \'nfold\'."
  errorvec[40] <- "\'LVQoutput\' must be of one of the following classes: \'trainoutput\', \'traintestoutput\', \'nfoldoutput\'."
  errorvec[41] <- "\'relevances\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[42] <- "\'costcurve\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[43] <- "\'relevanceprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[44] <- "\'testerror\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[45] <- "Relevance plotting is not available since there are no relevances to show."
  errorvec[46] <- "Costcurve plotting is not available since there is no costcurve to show."
  errorvec[47] <- "Relevanceprogress plotting is not available since there is no relevanceprogress to show."
  errorvec[48] <- "Testerror plotting is not available since there are no testerrors to show."
  errorvec[49] <- "\'relfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[50] <- "\'costfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[51] <- "\'relprogfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[52] <- "\'relfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[53] <- "\'costfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[54] <- "\'relprogfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[55] <- "\'inp\' must be of class \'matrix\' or \'NA\'."
  errorvec[56] <- "\'inp\' must contain points of at least one value and a label."
  errorvec[57] <- "\'testinp\' must be of class \'matrix\' or \'NA\'."
  errorvec[58] <- "\'testinp\' must contain points of at least one value and a label."
  errorvec[59] <- "\'trainerror\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[60] <- "\'trainerror\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[61] <- "Trainerror plotting is not available since there are no trainerrors to show."
  errorvec[62] <- "\'testerrorprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[63] <- "Testerrorprogress-output is only available in validationschemes \'traintest\' and \'nfold\'."
  errorvec[64] <- "\'trainerrorprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[65] <- "\'trainerrorprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[66] <- "Trainerror plotting is not available since there are no trainerrors to show."
  errorvec[67] <- "\'testerrorprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[68] <- "Testerror plotting is not available since there are no testerrors to show."
  errorvec[69] <- "\'trainerrorfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[70] <- "\'trainerrorfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[71] <- "\'testerrorfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[72] <- "\'testerrorfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[73] <- "\'alfa\' must contain exactly one value of class \'numeric\' or \'integer\'."
  errorvec[74] <- "\'alfa\' must contain a number greater than 1."
  errorvec[75] <- "\'optimisationscheme\' must contain exactly one value of the following: \'normal\', \'general\'."
  errorvec[76] <- "When using LVQscheme \'cauchyschwarz\' or \'renyi\' initialisationscheme \'zero\' is not available."
  errorvec[77] <- "\'prototypes\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[78] <- "\'prototypeprogress\' must contain exactly one value. This value must be either \'TRUE\' or \'FALSE\'."
  errorvec[79] <- "\'protofold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[80] <- "\'protoprogfold\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[81] <- "\'protofold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[82] <- "\'protoprogfold\' must be a whole number in the range of [1...number of folds] or -1."
  errorvec[83] <- "Cannot select a fold when the output object is not of the form \'nfoldoutput\'."
  errorvec[84] <- "\'fold\' must be a whole number in the range [1...number of folds] or -1."
  errorvec[85] <- "\'fold\' must be a number of class \'numeric\' or \'integer\'."
  errorvec[86] <- "When using LVQscheme \'cauchyschwarz\' or \'renyi\' the (test)data may not contain negative values and each datapoint must sum up to 1."
  errorvec[87] <- "\'relevancescheme\' must contain exactly one value of the following modes: \'global\', \'local\', \'classwise\'."
  errorvec[88] <- "When using \'relevancescheme\' \'relevance\' \'relevances\' must be \'NA\' or of class \'vector\',"
  errorvec[89] <- "When using \'relevancescheme\' \'matrix\' \'relevances\' must be \'NA\' or of class \'matrix\',"
  errorvec[90] <- "\'relevancenumber\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[91] <- "\'relevanceprognumber\' must contain exactly 1 value of class\'numeric\' or \'integer\'."
  errorvec[92] <- "\'relevancenumber\' must be a whole number in the range of [1...number of relevance-vectors/matrices] or -1."
  errorvec[93] <- "\'relevanceprognumber\' must be a whole number in the range of [1...number of relevance-vectors/matrices] or -1."
  errorvec[94] <- "When using the \'cauchyschwarz\'- or \'renyi\'-LVQscheme relevances are not available."

  cat("Error ", errornum, "\t: ", errorvec[errornum], '\n\n')
}