% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeNA.R
\name{summarizeNA}
\alias{summarizeNA}
\title{Summarize missing data patterns}
\usage{
summarizeNA(
  data,
  repetition = NULL,
  sep = "",
  newnames = c("variable", "frequency", "missing.pattern", "n.missing"),
  keep.data = TRUE
)
}
\arguments{
\item{data}{[data.frame] dataset containing the observations.}

\item{repetition}{[formula] Specify the structure of the data when in the long format: the time/repetition variable and the grouping variable, e.g. ~ time|id.
When specified the missing data pattern is specific to each variable not present in the formula.}

\item{sep}{[character] character used to separate the missing data indicator (0/1) when naming the missing data patterns.}

\item{newnames}{[character vector of length 4] additional column containing the variable name (only when argument \code{repetition} is used),
the frequency of the missing data pattern in the dataset, the name of the missing data pattern in the dataset, and the number of missing data per pattern.}

\item{keep.data}{[logical] should the indicator of missing data per variable in the original dataset per pattern be output.}
}
\value{
a data frame
}
\description{
Summarize missing data patterns.
}
\examples{
data(gastricbypassW, package = "LMMstar")
summarizeNA(gastricbypassW) 
summarizeNA(gastricbypassW, keep.data = FALSE)

data(gastricbypassL, package = "LMMstar")
summarizeNA(gastricbypassL, repetition = ~time|id)

data(calciumL, package = "LMMstar")
mp <- summarizeNA(calciumL, repetition = ~visit|girl)
plot(mp, variable = "bmd")
summarizeNA(calciumL[,c("visit","girl","bmd")], repetition = ~visit|girl)

data(vasscoresW, package = "LMMstar")
summarizeNA(vasscoresW)
}
\seealso{
\code{\link{autoplot.summarizeNA}} for a graphical display.
}
