% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{abetaW}
\alias{abetaW}
\title{Data From The abeta Study (Wide Format)}
\usage{
data(abetaW)
}
\description{
Extract data from a longitudinal case control study including 87 patients newly diagnosed with bipolar disorder and 44 age and sex matched healthy controls.
Contains demographic data and lifestyle factors at baseline, as well as measures of psychosocial functioning at baseline and 1 year follow-up.
This dataset is in the wide format (i.e. one line per participant).

\itemize{
\item \code{id}: study participant.
\item \code{sex}: male (M) or female (F).
\item \code{age}: age in years.
\item \code{group}: bipolar disorder (BD) or healthy control (HC).
\item \code{episode}: whether the patient experience an affective episode during follow-up.
\item \code{fast0},\code{fast1}: functioning assessment short test at baseline and follow-up.
\item \code{qol0},\code{qol1}: WHO quality of life score at baseline and follow-up.
\item \code{pss0},\code{pss1}: perceived stress score at baseline and follow-up.
\item \code{educationyears}: years of education including basic school.
\item \code{alcohol}: daily alcohol consumption.
\item \code{missingreason}: reason of drop out or missed visit.
}
}
\references{
Pech, Josefine, et al. "The impact of a new affective episode on psychosocial functioning, quality of life and perceived stress in newly diagnosed patients with bipolar disorder: A prospective one-year case-control study."Journal of Affective Disorders 277 (2020): 486-494.
}
\keyword{data}
