% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{EXP}
\alias{EXP}
\title{Exponential Structure}
\usage{
EXP(formula, var.cluster, var.time, nugget = FALSE, add.time)
}
\arguments{
\item{formula}{formula indicating on which variable to stratify the residual variance and correlation (left hand side)
and variables influencing the residual variance and correlation (right hand side).}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{nugget}{[logical] whether a nugget effect is present.}

\item{add.time}{not used.}
}
\value{
An object of class \code{EXP} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure where the residuals have a correlation decreasing exponentially,
Can be stratified on a categorical variable.
}
\details{
A typical formula would be \code{~1}, indicating a variance constant over time and correlation with exponential decrease over time.

Inspired from \code{nlme::corExp} where if \eqn{K} denotes the nugget effect and \eqn{\rho} the time effect,
the correlation between two observations with a time gap \eqn{dt} is \eqn{exp(-\rho dt)} when no nugget effect is present and \eqn{(1-K) exp(-\rho dt)} when a nugget effect is assumed.
}
\examples{
EXP(var.cluster = "id", var.time = "time", add.time = TRUE)
EXP(~space, var.cluster = "id", var.time = "time", add.time = TRUE)
EXP(list(~space,~space), var.cluster = "id", var.time = "time", add.time = TRUE)

}
