% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{deviance.LMMsolve}
\alias{deviance.LMMsolve}
\title{Deviance of an LMMsolve object}
\usage{
\method{deviance}{LMMsolve}(object, includeConstant = TRUE, ...)
}
\arguments{
\item{object}{an object of class LMMsolve}

\item{includeConstant}{Should the constant in the restricted log-likelihood
be included. Default is \code{TRUE}, as for example in \code{lme4} and SAS.
In \code{asreml} the constant is omitted.}

\item{...}{some methods for this generic require additional arguments.
None are used in this method.}
}
\value{
The deviance of the fitted model.
}
\description{
Obtain the deviance of a model fitted using LMMsolve.
}
\examples{
## Fit model on john.alpha data from agridat package.
data(john.alpha, package = "agridat")

## Fit simple model with only fixed effects.
LMM1 <- LMMsolve(fixed = yield ~ rep + gen,
                data = john.alpha)

## Obtain deviance.
logLik(LMM1)

## Obtain deviance. without constant.
logLik(LMM1, includeConstant = FALSE)

}
