% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lmd.R
\name{plot_lmd}
\alias{plot_lmd}
\title{LMD Plot}
\usage{
plot_lmd(
  lmd_obj,
  max_pf = length(lmd_obj[["pf"]]),
  show_residue = TRUE,
  pricolor_plot = "midnightblue",
  line_size_plot = 1
)
}
\arguments{
\item{lmd_obj}{LMD object created from LMD function}

\item{max_pf}{Number of PFs to Plot}

\item{show_residue}{Whether to plot residue or not}

\item{pricolor_plot}{color of plots}

\item{line_size_plot}{Size of line in ggplot}
}
\value{
ggplot plot for Product Functions (PFs) and Residue
}
\description{
Method for plotting Product Functions (PFs) and Residue
}
\examples{
x=1:100
y = (2 / 3 )* sin(x * 30) + (2 / 3) * sin(x * 17.5) + (4 / 5) *cos(x * 2)
plot_lmd(lmd(y))
}
\author{
Shubhra Prakash, \email{shubhraprakash279@gmail.com}
}
\keyword{LMD}
\keyword{PF}
\keyword{Residue}
