% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sql_agent.R
\name{build_sql_agent}
\alias{build_sql_agent}
\title{Build a SQL Agent Graph}
\arguments{
\item{model}{A function that accepts prompts and returns LLM responses.}

\item{connection}{A DBI connection object to the target SQL database.}

\item{n_samples}{Number of candidate SQL plans to consider (used in prompt).}

\item{human_validation}{Whether to include a human review node.}

\item{bypass_recommended_steps}{If TRUE, skip the step recommendation node.}

\item{bypass_explain_code}{If TRUE, skip the final explanation step.}

\item{verbose}{Logical indicating whether to print progress messages (default: TRUE).}
}
\value{
A compiled SQL agent function that runs via a state machine (graph execution).
}
\description{
This function constructs a full SQL database agent using a graph-based workflow.
It supports step recommendation, SQL code generation, error handling, optional human review,
and automatic explanation of the final code.
}
\examples{
\dontrun{
agent <- build_sql_agent(
  model = call_llm,
  connection = DBI::dbConnect(RSQLite::SQLite(), ":memory:"),
  human_validation = FALSE,
  verbose = TRUE
)
state <- list(user_instructions = "Which Categories bring in the highest total revenue# Hint: ...")
agent(state)
}
}
