% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLHD.B2001.R
\name{OLHD.B2001}
\alias{OLHD.B2001}
\title{Orthogonal Latin Hypercube Design}
\usage{
OLHD.B2001(n, k)
}
\arguments{
\item{n}{An odd prime number that is greater than or equal to 3.}

\item{k}{A positive integer that is smaller than or equal to n-1.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} orthogonal LHD.
}
\description{
\code{OLHD.B2001} returns a \code{n} by \code{k} orthogonal Latin hypercube design generated by the construction method of Butler (2001)
}
\examples{
#create an orthogonal LHD with n=11 and k=5
OLHD.B2001(n=11,k=5)

#create an orthogonal LHD with n=7 and k=6
OLHD.B2001(n=7,k=6)

}
\references{
Butler, N.A. (2001) Optimal and orthogonal Latin hypercube designs for computer experiments. \emph{Biometrika}, \strong{88}(3), 847-857.
}
