% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPC_LFM.R
\name{IPC_LFM}
\alias{IPC_LFM}
\title{Apply the IPC method to the Laplace factor model}
\usage{
IPC_LFM(data, m, A, D, p)
}
\arguments{
\item{data}{The data used in the IPC analysis.}

\item{m}{The number of common factors.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list of metrics including:
\item{Ai}{Estimated factor loadings updated during the IPC analysis, a matrix of estimated factor loadings.}
\item{Di}{Estimated uniquenesses updated during the IPC analysis, a vector of estimated uniquenesses corresponding to each variable.}
\item{MSESigmaA}{Mean squared error of the estimated factor loadings (Ai) compared to the true loadings (A).}
\item{MSESigmaD}{Mean squared error of the estimated uniquenesses (Di) compared to the true uniquenesses (D).}
\item{LSigmaA}{Loss metric for the estimated factor loadings (Ai), indicating the relative error compared to the true loadings (A).}
\item{LSigmaD}{Loss metric for the estimated uniquenesses (Di), indicating the relative error compared to the true uniquenesses (D).}
}
\description{
This function performs Incremental Principal Component Analysis (IPC) on the provided data. It updates the estimated factor loadings and uniquenesses as new data points are processed, calculating mean squared errors and loss metrics for comparison with true values.
}
\examples{
library(SOPC)
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- IPC_LFM(data, m, A, D, p)
print(results)
}
