% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_on_LDA.R
\name{prep_TS_data}
\alias{prep_TS_data}
\title{Prepare the model-specific data to be used in the TS analysis
  of LDA output}
\usage{
prep_TS_data(document_covariate_table, LDA_models, mods, i = 1)
}
\arguments{
\item{document_covariate_table}{Document covariate table (rows: documents,
columns: time index and covariate options). Every model needs a
covariate to describe the time value for each document (in whatever 
units and whose name in the table is input in \code{timename})
that dictates the application of the change points. 
In addition, all covariates named within specific models in
\code{formula} must be included. Must be a conformable to a data table,
as verified by \code{\link{check_document_covariate_table}}.}

\item{LDA_models}{List of LDA models (class \code{LDA_set}, produced by
\code{\link{LDA_set}}) or a singular LDA model (class \code{LDA},
produced by \code{\link[topicmodels]{LDA}}).}

\item{mods}{The \code{data.table} created by \code{\link{expand_TS}} that 
contains each of the models (defined by the LDA model to use and the and
formula number of changepoints for the TS model). Indexed here by 
\code{i}.}

\item{i}{\code{integer} index referencing the row in \code{mods} to use.}
}
\value{
Class \code{data.frame} object including [1] the time variable
  (indicated in \code{control}), [2] the predictor variables (required by
  \code{formula}) and [3], the multinomial response variable (indicated
  in \code{formula}), ready for input into \code{TS}.
}
\description{
Append the estimated topic proportions from a fitted LDA model 
  to the document covariate table to create the data structure needed for 
  \code{\link{TS}}.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDAs <- LDA_set(document_term_table, topics = 2:3, nseeds = 2)
  LDA_models <- select_LDA(LDAs)
  weights <- document_weights(document_term_table)
  formulas <- c(~ 1, ~ newmoon)
  mods <- expand_TS(LDA_models, formulas = ~1, nchangepoints = 0)
  data1 <- prep_TS_data(document_covariate_table, LDA_models, mods)
}

}
