% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_corr.R
\name{bkg_corr}
\alias{bkg_corr}
\title{Background correction function}
\usage{
bkg_corr(raw.spec, corr.norm)
}
\arguments{
\item{raw.spec}{Raw spectrum}

\item{corr.norm}{Vector of the base-line correction and edge-step normalization values (vector of length 4)}
}
\description{
This function allows you to base-line correct and edge-step normalize XANES spectra (background correction).
Raw spectra are loaded, then base-line corrected and edge-step normalized. The spectrum is flattened after E0.
The function returns the corrected, normalized and flattened spectrum
}
\examples{
data(stdmix)
corr.spec.samples <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec <- bkg_corr(raw.spec = corr.spec.samples[[1]], 
  corr.norm = c(-36, -15, 37, 58))
print(corr.spec)
}
\keyword{correction,}
\keyword{flattening}
\keyword{normalization,}
