% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_frontier.R
\name{geom_frontier}
\alias{geom_frontier}
\alias{stat_frontier}
\title{Plotting the Pareto Optimal Frontier}
\usage{
geom_frontier(mapping = NULL, data = NULL, position = "identity",
  direction = "vh", na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  ...)

stat_frontier(mapping = NULL, data = NULL, geom = "step",
  position = "identity", direction = "vh", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, quadrant = "top.right", ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes} or
\code{aes_}. If specified and \code{inherit.aes = TRUE} (the default), it is
combined with the default mapping at the top level of the plot. You must
supply mapping if there is no plot mapping.}

\item{data}{The data to be displayed in this layer.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{direction}{Direction of stairs: 'vh' for vertical then horizontal, or 'hv'
for horizontal then vertical.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. borders.}

\item{...}{Other arguments passed on to \code{layer}. These are often
aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters to the
paired \code{geom}/\code{stat}.}

\item{geom}{Use to override the default connection between
\code{geom_frontier} and \code{stat_frontier}.}

\item{quadrant}{See \code{\link{get_frontier}}.}
}
\description{
The frontier geom is used to overlay the efficient frontier on a scatterplot.
}
\examples{

\dontrun{

# default will find the efficient front in top right quadrant
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  geom_frontier()

# change the direction of the steps
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  geom_frontier(direction = 'hv')

# use quadrant parameter to change how you define the efficient frontier
ggplot(airquality, aes(Ozone, Temp)) +
  geom_point() +
  geom_frontier(quadrant = 'top.left')

ggplot(airquality, aes(Ozone, Temp)) +
  geom_point() +
  geom_frontier(quadrant = 'bottom.right')
}

}
