/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.kr.KoreanTokenizer;
import org.apache.lucene.analysis.kr.KoreanTokenizerImpl;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.MorphAnalyzer;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordSpaceAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoreanFilter
extends TokenFilter {
    private LinkedList<Token> koreanQueue = new LinkedList();
    private MorphAnalyzer morph = new MorphAnalyzer();
    WordSpaceAnalyzer wsAnal = new WordSpaceAnalyzer();
    private boolean bigrammable = false;
    private boolean hasOrigin = false;
    private static final String APOSTROPHE_TYPE = KoreanTokenizerImpl.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = KoreanTokenizerImpl.TOKEN_TYPES[2];

    public KoreanFilter(TokenStream input) {
        super(input);
    }

    public KoreanFilter(TokenStream input, boolean bigram) {
        this(input);
        this.bigrammable = bigram;
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has) {
        this(input, bigram);
        this.hasOrigin = has;
    }

    public Token next(Token result) throws IOException {
        if (this.koreanQueue.size() > 0) {
            return this.koreanQueue.removeFirst();
        }
        int skippedPositions = 0;
        try {
            while ((result = this.input.next(result)) != null) {
                if ((result = result.type().equals(KoreanTokenizer.TOKEN_TYPES[8]) ? this.analysisKorean(result, skippedPositions) : this.analysisETC(result)) == null) {
                    ++skippedPositions;
                    continue;
                }
                return result;
            }
        }
        catch (MorphException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    private Token analysisKorean(Token token, int skipinc) throws MorphException {
        String input = token.termText();
        List outputs = this.morph.analyze(input);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (((AnalysisOutput)outputs.get(0)).getScore() == 100) {
            this.extractKeyword(outputs, map);
        } else {
            List list = this.wsAnal.analyze(input);
            this.extractKeyword(list, map);
        }
        Iterator<String> iter = map.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String text = iter.next();
            int index = input.indexOf(text);
            Token t = new Token(text, token.startOffset() + (index != -1 ? index : 0), index != -1 ? token.startOffset() + index + text.length() : token.endOffset(), KoreanTokenizer.TOKEN_TYPES[8]);
            if (i == 0) {
                t.setPositionIncrement(token.getPositionIncrement() + skipinc);
            } else {
                t.setPositionIncrement(0);
            }
            this.koreanQueue.add(t);
            ++i;
        }
        if (this.koreanQueue.size() == 0) {
            return null;
        }
        return this.koreanQueue.removeFirst();
    }

    private void extractKeyword(List<AnalysisOutput> outputs, HashMap<String, Integer> map) throws MorphException {
        for (AnalysisOutput output : outputs) {
            System.out.println(output.toString());
            if (output.getPos() != 'V') {
                map.put(output.getStem(), new Integer(1));
            } else {
                map.put(String.valueOf(output.getStem()) + "\ub2e4", new Integer(1));
            }
            if (output.getScore() == 100) {
                List<CompoundEntry> cnouns = output.getCNounList();
                int jj = 0;
                while (jj < cnouns.size()) {
                    CompoundEntry cnoun = cnouns.get(jj);
                    if (cnoun.getWord().length() > 1) {
                        map.put(cnoun.getWord(), new Integer(0));
                    }
                    if (jj == 0 && cnoun.getWord().length() == 1) {
                        map.put(String.valueOf(cnoun.getWord()) + cnouns.get(jj + 1).getWord(), new Integer(0));
                    } else if (jj > 1 && cnoun.getWord().length() == 1) {
                        map.put(String.valueOf(cnouns.get(jj).getWord()) + cnoun.getWord(), new Integer(0));
                    }
                    ++jj;
                }
                continue;
            }
            if (!this.bigrammable) continue;
            this.addBiagramToMap(output.getStem(), map);
        }
    }

    private void addBiagramToMap(String input, HashMap map) {
        int offset = 0;
        int strlen = input.length();
        while (offset < strlen - 1) {
            String text;
            if (this.isAlphaNumChar(input.charAt(offset))) {
                text = this.findAlphaNumeric(input.substring(offset));
                map.put(text, new Integer(0));
                offset += text.length();
                continue;
            }
            text = input.substring(offset, offset + 2 > strlen ? strlen : offset + 2);
            map.put(text, new Integer(0));
            ++offset;
        }
    }

    private String findAlphaNumeric(String text) {
        int pos = 0;
        int i = 0;
        while (i < text.length()) {
            if (!this.isAlphaNumChar(text.charAt(i))) break;
            ++pos;
            ++i;
        }
        return text.substring(0, pos);
    }

    private Token analysisETC(Token t) throws MorphException {
        char[] buffer = t.termBuffer();
        int bufferLength = t.termLength();
        String type = t.type();
        if (type == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            t.setTermLength(bufferLength - 2);
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            int i = 0;
            while (i < bufferLength) {
                char c = buffer[i];
                if (c != '.') {
                    buffer[upto++] = c;
                }
                ++i;
            }
            t.setTermLength(upto);
        }
        return t;
    }

    private boolean isAlphaNumChar(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 122;
    }

    public void setHasOrigin(boolean has) {
        this.hasOrigin = has;
    }
}

