% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.oc.comb.kb.R
\name{get.oc.comb.kb}
\alias{get.oc.comb.kb}
\title{Operating Characteristics for Drug-combination Trials}
\usage{
get.oc.comb.kb(
  target,
  p.true,
  ncohort,
  cohortsize,
  n.earlystop = 100,
  marginL = 0.05,
  marginR = 0.05,
  startdose = c(1, 1),
  cutoff.eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05,
  ntrial = 1000
)
}
\arguments{
\item{target}{The target dose-limiting toxicity (DLT) rate.}

\item{p.true}{A \code{J*K} matrix \code{(J<=K)} containing the true toxicity
probabilities of combinations with \code{J} dose levels of
agent A and \code{K} dose levels of agent B.}

\item{ncohort}{A scalar specifying the total number of cohorts in the trial.}

\item{cohortsize}{The number of patients in the cohort.}

\item{n.earlystop}{The early stopping parameter. If the number of patients
treated at the current dose reaches \code{n.earlystop},
then we stop the trial and select the MTD based on the observed
data.\cr
The default value is 100.}

\item{marginL}{The difference between the target and the lower bound of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{marginR}{The difference between the target and the upper bound of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{startdose}{The starting dose combination level for the
drug-combination trial.\cr
The default is c(1, 1).}

\item{cutoff.eli}{The cutoff value to eliminate an overly toxic dose and all
higher doses for safety.\cr
The default value is 0.95.}

\item{extrasafe}{Set \code{extrasafe=TRUE} to impose a stricter
stopping rule.\cr
The default is FALSE.}

\item{offset}{A small positive number (between 0 and 0.5) to control how
strict the stopping rule is when \code{extrasafe=TRUE}. A
larger value leads to a stricter stopping rule.\cr
The default value is 0.05.}

\item{ntrial}{The total number of trials to be simulated. \cr
The default value is 1000.}
}
\value{
The function returns the operating characteristics of the Keyboard
  combination design as a list: \cr
 \enumerate{
  \item the true toxicity probability at each dose level (\code{$p.true}),\cr
  \item the selection percentage at each dose level (\code{$selpercent}),\cr
  \item the percentage of correct selection (\code{$pcs}),\cr
  \item the number of patients treated at each dose level (\code{$nptsdose}),\cr
  \item the number of toxicities observed at each dose level (\code{$ntoxdose}),\cr
  \item the total number of toxicities observed in the trial (\code{$totaltox}),\cr
  \item the total number of patients in the trial (\code{$totaln}),\cr
  \item the total percentage of patients treated at the MTD (\code{$npercent}).
}
}
\description{
This function generates the operating characteristics of the Keyboard design for
drug-combination trials.
}
\section{Uses}{

This function uses \code{\link{get.boundary.comb.kb}}
}

\examples{
### Drug-combination trial ###

p.true <- matrix(c(0.01, 0.03, 0.10, 0.20, 0.30,
                   0.03, 0.05, 0.15, 0.30, 0.60,
                   0.08, 0.10, 0.30, 0.60, 0.75), byrow=TRUE, ncol=5)

oc.comb <- get.oc.comb.kb(target=0.3, p.true=p.true, ncohort=20, cohortsize=3,
                          n.earlystop=12, startdose=c(1, 1), ntrial=100)

}
\references{
Yan F, Mandrekar SJ, Yuan Y. Keyboard: A Novel Bayesian Toxicity Probability
Interval Design for Phase I Clinical Trials.
\emph{Clinical Cancer Research}. 2017; 23:3994-4003.
http://clincancerres.aacrjournals.org/content/23/15/3994.full-text.pdf


Pan H, Lin R, Yuan Y. Keyboard design for phase I drug-combination trials.
\emph{Contemporary Clinical Trials}. 2020.
https://doi.org/10.1016/j.cct.2020.105972
}
\seealso{
Other drug-combination functions: 
\code{\link{get.boundary.comb.kb}()},
\code{\link{next.comb.kb}()},
\code{\link{select.mtd.comb.kb}()}
}
\author{
Hongying Sun, Li Tang, and Haitao Pan
}
\concept{drug-combination functions}
