% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{weight_pow_dist}
\alias{weight_pow_dist}
\title{Generic weighted p-distance}
\usage{
weight_pow_dist(x, y, w, p)
}
\arguments{
\item{x}{First vector.}

\item{y}{Second vector.}

\item{w}{Weights for every coordinate in the vectors.}

\item{p}{Powers for every coordinate in the vectors. To define a true norm every coordinate
has to be greater than 1.}
}
\value{
Real value of the weighted p-distance.
}
\description{
Many isotropic models can be defined employing a distance. In particular this 
function implements a distance employing weights and different powers.
}
\examples{
library(KRIG)

n<-1e5
x<-runif( n )
y<-runif( n )
p<-rep(2.5,n)
w<-runif(n)

kw<-weight_pow_dist( x, y, w, p )
nw<-sum( w * abs( x - y )^p )

nw == kw
}
\author{
Pedro Guarderas \email{pedro.felipe.guarderas@gmail.com}.
}
