% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Kanova}
\alias{Kanova}
\title{KANOVA, kernel anova under RKHS approximations.}
\usage{
Kanova(Kernels, Integral, X)
}
\arguments{
\item{Kernels}{data.frame of kernels composed by four columns.
\enumerate{
  \item Kernel name.
  \item Inferior limit for integral.
  \item Superior limit for integral.
  \item Number of steps for discretization of integrals.
}}

\item{Integral}{A list containing the results of kernel integrals of the functions
\code{\link{vector_integrate_kernel}}.}

\item{X}{matrix containing in each row the coordinate where the one coordinate integrals will 
be evaluated.}
}
\value{
List with containing the Gamma 3D array where the different combination variance are
stocked and the total matrix variance named Kanova.
}
\description{
Under an approximation to the sensitivity analysis based in variance computation
the different indexes of combinatorial sensitivity values can be computed employing the
values of kernel integrals.
}
\references{
\insertRef{Kanova:2013}{KRIG}
\insertRef{Aronszajn:ThRK}{KRIG}
}
\seealso{
For a complete application you can check the documentation of \code{\link{Krigvar}}.
}
\author{
Pedro Guarderas \email{pedro.felipe.guarderas@gmail.com}.
}
