% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparsePlot.R
\name{SparsePlot}
\alias{SparsePlot}
\title{Sparse plot}
\usage{
SparsePlot(Lt, interval, ...)
}
\arguments{
\item{Lt}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation time in ascending order for each subject.}

\item{interval}{A \code{vector} of length two denoting the supporting interval.}

\item{...}{Other arguments passed into \code{\link[graphics]{plot}}.}
}
\value{
Create the corresponding sparse plot.
}
\description{
Create sparse plot to see the sparsity of the data.
}
\details{
For the sparse plot, x-axis is the observation time while y-axis represents various subjects.
}
\examples{
# Generate data
n <- 100
interval <- c(0, 10)
lambda_1 <- 9 #the first eigenvalue
lambda_2 <- 1.5 #the second eigenvalue
eigfun <- list()
eigfun[[1]] <- function(x){cos(pi * x/10)/sqrt(5)}
eigfun[[2]] <- function(x){sin(pi * x/10)/sqrt(5)}
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
# DataNew1 and DataNew2 have different sparsity
DataNew1 <- GenDataKL(n, interval = interval, sparse = 6:8,
                      meanfun = function(x){0}, score = score,
                      eigfun = eigfun, sd = sqrt(0.1))
DataNew2 <- GenDataKL(n, interval = interval, sparse = 2:4,
                      meanfun = function(x){0}, score = score,
                      eigfun = eigfun, sd = sqrt(0.1))
# Create sparse plots
par(mfrow = c(1, 2))
SparsePlot(DataNew1$Lt, interval = interval)
SparsePlot(DataNew2$Lt, interval = interval)
par(mfrow = c(1, 1))
}
