% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SSModel.R
\name{plot.SSModel}
\alias{plot.SSModel}
\title{Diagnostic Plots of State Space Models}
\usage{
\method{plot}{SSModel}(x, nsim = 0, ...)
}
\arguments{
\item{x}{Object of class \code{SSModel}.}

\item{nsim}{The number of independent samples used in importance sampling.
Only used for non-Gaussian model. Default is 0, which computes the
approximating Gaussian model by \code{\link{approxSSM}} and performs the
usual Gaussian filtering/smoothing so that the smoothed state estimates
equals to the conditional mode of \eqn{p(\alpha_t|y)}{p(\alpha[t]|y)}.
In case of \code{nsim = 0}, the mean estimates and their variances are computed using
the Delta method (ignoring the covariance terms).}

\item{...}{Ignored.}
}
\description{
Diagnostic plots based on standardized residuals for objects of class \code{SSModel}.
}
\examples{
modelNile <- SSModel(Nile ~ SSMtrend(1, Q = list(matrix(NA))), H = matrix(NA))
modelNile <- fitSSM(inits = c(log(var(Nile)),log(var(Nile))), model = modelNile,
 method = "BFGS")$model

if (interactive()) {
  plot(modelNile)
}
}
