% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaCall}
\alias{juliaCall}
\title{Call a Julia function by name}
\usage{
juliaCall(name, ...)
}
\arguments{
\item{name}{name of the Julia function. May be prefixed with a package or module
path.}

\item{...}{parameters handed to the function. Will be translated
to Julia data structures}
}
\value{
The value returned from Julia, translated to an R data structure.
If Julia returns \code{nothing}, an invisible \code{NULL} is returned.
}
\description{
Call a Julia function via specifying the name as string and get the translated result.
It is also possible to use a dot at the end of the function name
for applying the function in a vectorized manner via "broadcasting" in Julia.
}
\examples{
if (juliaSetupOk()) {

   juliaCall("/", 4, 2)
   juliaCall("Base.div", 4, 2)
   juliaCall("sin.", c(1,2,3))
   juliaCall("Base.cos.", c(1,2,3))

}
\dontshow{
JuliaConnectoR:::stopJulia()
}

}
