% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot}
\alias{traceplot}
\alias{traceplot.JointAI}
\title{Traceplot of a JointAI model}
\usage{
traceplot(object, ...)

\method{traceplot}{JointAI}(object, start = NULL, end = NULL, thin = NULL,
  subset = "main", nrow = NULL, ncol = NULL, ...)
}
\arguments{
\item{object}{object inheriting from class \code{JointAI}}

\item{...}{Arguments passed on to \code{graphics::matplot}
\describe{
  \item{lty}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{lwd}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{lend}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{col}{vector of colors.  Colors are used cyclically.}
  \item{cex}{vector of character expansion sizes, used cyclically.
    This works as a multiple of \code{\link{par}("cex")}.  \code{NULL} is
    equivalent to \code{1.0}. }
  \item{bg}{vector of background (fill) colors for the open plot
    symbols given by \code{pch = 21:25} as in \code{\link{points}}.  The
    default \code{NA} corresponds to the one of the underlying function
    \code{\link{plot.xy}}.}
  \item{xlim}{ranges of x and y axes, as in \code{\link{plot}}.}
  \item{ylim}{ranges of x and y axes, as in \code{\link{plot}}.}
  \item{add}{logical.  If \code{TRUE}, plots are added to current one,
    using \code{\link{points}} and \code{\link{lines}}.}
  \item{verbose}{logical.  If \code{TRUE}, write one line of what is
    done.}
}}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{subset}{subset of monitored parameters (columns in the MCMC sample).
Can be specified as a numeric vector of columns, a vector of
column names, as \code{subset = "main"} or \code{NULL}.
If \code{NULL}, all monitored nodes will be plotted.
\code{subset = "main"} (default) the main parameters of the
analysis model will be plotted (regression coefficients/fixed
effects, and, if available, standard deviation of the residual
and random effects covariance matrix).}

\item{nrow}{optional; number of rows in the plotting layout
(determined automatically if not specified)}

\item{ncol}{optional; number of columns in the plotting layout
(determined automatically if not specified)}
}
\description{
Creates a set of traceplots from the MCMC sample of an object of class JointAI
}
\examples{
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
traceplot(mod)

}
\seealso{
\code{\link{summary.JointAI}}, \code{\link{lme_imp}}, \code{\link{glm_imp}},
          \code{\link{lm_imp}}
}
