% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_pattern.R
\name{md_pattern}
\alias{md_pattern}
\title{Missing data pattern}
\usage{
md_pattern(data, plot = TRUE, xlab = "", ylab = "", xaxis_pars = list(),
  yaxis_pars = list(), printN = TRUE, print = TRUE, ...)
}
\arguments{
\item{data}{data frame}

\item{plot}{logical; should the missing data pattern be plotted?}

\item{xlab}{label for the x-axis}

\item{ylab}{label for the y-axis}

\item{xaxis_pars}{list of optional parameters for the x-axis}

\item{yaxis_pars}{list of optional parameters for the y-axis}

\item{printN}{logical; should the title "N" of the y-axis be printed?}

\item{print}{should the missing data pattern be returned as a matrix?}

\item{...}{optional additional parameters passed to \code{\link[graphics]{image}()}}
}
\description{
Plot the pattern of missing data. The missing data pattern is determined
using the function \code{\link[mice]{md.pattern}} from the
\href{https://CRAN.R-project.org/package=mice}{\code{mice}} package.
}
\examples{
md_pattern(wideDF)

par(mar = c(3, 1, 1.5, 1.5), mgp = c(2, 0.6, 0))
md_pattern(longDF, yaxis_pars = list(cex.axis = 0.8))

}
