\name{RE.Johnson}
\alias{RE.Johnson}

\title{Johnson transformation}
\description{
Johnson transform to normality using the Z family of distributions. 
Performs the Johnson Transformation based on the method of the percentiles.
Returns the the transformed variable, the function used and de p-value of the transformation.
}
\usage{
RE.Johnson(x)

}

\arguments{
  \item{x}{
x  vector of observations
}
}
\details{
The values of the Johnson Transformation Function can be obtained
}
\value{
The objects returned consists of the following items:
function     type of function used in transformation (SB,SL or SU)
p-value      the resulting p-value of the transformation
transformed  the data vector of transformed variable
f.gamma, f.lambda, f.epsilon and f.eta    the values of the variables in the transformation function. 
}
\references{
Chou, Youn Min; Polansky, A. M. M. R. L. (1998), "Transforming non normal data to normality in
statistical process control", Journal of Quality Technology 30, 2, April.

Johnson, N. L. (1949), "Systems of Frequency Curves Generated by Methods of Translation". URL:
http://www.jstor.org/stable/2332539

Slifker, J. F. & Shapiro, S. S. (1980), "The johnson system: selection and parameter estimation",
Technometrics 22(2).

}
\author{
Edgar Santos Fernandez
}
\note{
Note that the transformed variable often present a good fit to the normal distribution.
}



\seealso{
<pkg>
}
\examples{

# transforming to normality a random sample with beta distribution
x <- rbeta(30,2,3)
y <- RE.Johnson(x); print(y)

# working with the transformed variable
x <- runif(100)
y <- RE.Johnson(x) $transformed ; print(y)

# working with the p-values
x <- rgamma(100,2,1)
y <- RE.Johnson(x)$p ;print(y)

}

\keyword{ ~kwd1 }
\keyword{ ~kwd2 }
