% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{getTracksTags}
\alias{getTracksTags}
\title{Search Jamendo database for a track}
\usage{
getTracksTags(tags, limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID"))
}
\arguments{
\item{tags}{Tags to seach for (genre, instrument, theme and nc tags)}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about a track.
See \url{https://developer.jamendo.com/v3.0/tracks} for more information.
}
\description{
Search by one or more tags (genre, instrument, theme and nc tags).
}
\examples{
\donttest{
##Examples
 tags <- c("chill","ambient")
 tracks <- getTracksTags(tags,limit=3)
}
}
