% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{getArtist}
\alias{getArtist}
\title{Search Jamendo database for an artist}
\usage{
getArtist(artist_id = NULL, artist_name = NULL,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID"))
}
\arguments{
\item{artist_id}{Artist ID to seach for}

\item{artist_name}{Artist name to seach for}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about an artist.
See \url{https://developer.jamendo.com/v3.0/artists} for more information.
}
\description{
Search Jamendo database for an artist. You can search for either an artist ID or an artist name.
}
\examples{
\donttest{
##Example
 artistID <- getArtist(artist_id="1510")
 artistName <- getArtist(artist_name="Judas Priestley")
}
}
